// ops-demo-contact-addon.v2.js
// Robust: removes stray info buttons, hides duplicate footers, adds ONE centered footer with QR.
// Uses a normal PNG file (avoids CSP blocks for data: images).
(() => {
  "use strict";
  if (window.__opsDemoContactAddonV2Loaded) return;
  window.__opsDemoContactAddonV2Loaded = true;

  const QR_SRC = "./qr-vcard-opsdeck360.png"; // put this PNG next to your HTML
  const EMAIL = "info@opsdeck360.de";
  const NAME_LINE = "Torsten Döpke • Diplom Wirt.-Info.";

  const $ = (sel, root=document) => root.querySelector(sel);
  const $$ = (sel, root=document) => Array.from(root.querySelectorAll(sel));

  function inHeaderInner(el){
    const hi = document.getElementById("header-inner");
    return !!(hi && el && hi.contains(el));
  }

  // Remove the extra left info button that is NOT part of the real header cluster
  function removeStrayInfoButtons() {
    const candidates = []
      .concat($$("#opsDemoInfoBtn, #opsHdrInfoBtn"))
      .concat($$("button, a"))
      .filter(Boolean);

    for (const el of candidates) {
      const txt = (el.textContent || "").trim();
      const title = (el.getAttribute("title") || "").toLowerCase();
      const aria = (el.getAttribute("aria-label") || "").toLowerCase();

      const looksLikeInfo =
        txt === "i" || txt === "ℹ" || txt === "ⓘ" ||
        title.includes("info") || aria.includes("info");

      if (!looksLikeInfo) continue;

      // Keep the one inside header-inner (the correct one)
      if (inHeaderInner(el)) continue;

      // Otherwise remove/hide it
      try { el.remove(); } catch(_) { el.style.display = "none"; }
    }
  }

  // Hide footers that were previously injected (so we end up with exactly one)
  function hideDuplicateFooters() {
    const nodes = []
      .concat($$("footer"))
      .concat($$("#opsDemoFooter"))
      .concat($$(".app-footer, .ops-footer-inner, .ops-demo-footer"));

    const matches = nodes.filter(n => n && (n.textContent || "").includes("Torsten") && (n.textContent || "").includes("opsdeck360"));
    for (const n of matches) {
      if (n && n.id !== "opsDemoContactFooter") {
        n.style.display = "none";
      }
    }
  }

  function ensureStyles() {
    if (document.getElementById("opsDemoContactCssV2")) return;
    const st = document.createElement("style");
    st.id = "opsDemoContactCssV2";
    st.textContent = `
      #opsDemoContactFooter{
        width:100%;
        border-top: 1px solid rgba(148,163,184,0.18);
        margin-top: 18px;
        background: rgba(2,6,23,0.35);
        backdrop-filter: blur(6px);
      }
      #opsDemoContactFooter .inner{
        max-width: 1360px;
        margin: 0 auto;
        padding: 12px 16px;
        display:flex;
        gap:12px;
        justify-content:center;
        align-items:center;
        flex-wrap:wrap;
        opacity: .92;
        font-size: 13px;
      }
      #opsDemoContactFooter a{
        color: inherit;
        text-decoration: none;
        border-bottom: 1px dotted rgba(255,255,255,0.35);
      }
      #opsDemoContactFooter a:hover{
        border-bottom-color: rgba(255,255,255,0.7);
      }
      #opsDemoContactFooter .sep{ opacity:.6; }

      #opsDemoQrThumb{
        width: 92px;
        height: 92px;
        border-radius: 14px;
        border: 1px solid rgba(255,255,255,0.14);
        background: rgba(255,255,255,0.06);
        padding: 6px;
        box-sizing: border-box;
        cursor: pointer;
      }
      #opsDemoQrThumb:hover{ border-color: rgba(255,255,255,0.28); }

      dialog.dialog#opsQrDialog { border:none; padding:0; background:transparent; }
      dialog.dialog#opsQrDialog::backdrop { background: rgba(0,0,0,0.55); }
      #opsQrDialog .card { max-width: 920px; width: 92vw; }
    `;
    document.head.appendChild(st);
  }

  function ensureFooter() {
    let f = document.getElementById("opsDemoContactFooter");
    if (f) return f;

    f = document.createElement("footer");
    f.id = "opsDemoContactFooter";
    f.innerHTML = `
      <div class="inner">
        <img id="opsDemoQrThumb" src="${QR_SRC}" alt="QR Code" title="QR Code (klicken zum Vergrößern)">
        <span>${NAME_LINE}</span>
        <span class="sep">•</span>
        <a href="mailto:${EMAIL}">${EMAIL}</a>
      </div>
    `;
    document.body.appendChild(f);
    return f;
  }

  function openDialog() {
    let dlg = document.getElementById("opsQrDialog");
    if (!dlg) {
      dlg = document.createElement("dialog");
      dlg.id = "opsQrDialog";
      dlg.className = "dialog";
      dlg.innerHTML = `
        <div class="card">
          <div class="ops-dialog-header">
            <div>
              <div class="ops-dialog-title">Kontakt – QR / vCard</div>
              <div class="ops-dialog-note">${NAME_LINE} • ${EMAIL}</div>
            </div>
            <button type="button" class="btn btn-ghost" data-close title="Schließen">✕</button>
          </div>

          <div style="padding:16px;text-align:center;">
            <img src="${QR_SRC}" alt="QR Code"
                 style="width:min(520px,90vw);height:auto;border-radius:18px;border:1px solid rgba(255,255,255,.14);background:rgba(255,255,255,.06);padding:10px;box-sizing:border-box;">
            <div style="margin-top:12px;opacity:.92;">
              <a href="mailto:${EMAIL}">${EMAIL}</a>
            </div>
          </div>

          <div class="card-footer" style="display:flex;justify-content:flex-end;gap:10px;padding:0 16px 16px;">
            <button type="button" class="btn" data-close>Schließen</button>
          </div>
        </div>
      `;
      document.body.appendChild(dlg);

      dlg.addEventListener("click", (ev) => { if (ev.target === dlg) dlg.close(); });
      dlg.querySelectorAll("[data-close]").forEach(b => b.addEventListener("click", () => dlg.close()));
    }
    try { dlg.showModal(); } catch(_) { dlg.setAttribute("open","open"); }
  }

  function init() {
    ensureStyles();
    hideDuplicateFooters();
    removeStrayInfoButtons();
    const f = ensureFooter();
    // wire up thumb
    const thumb = document.getElementById("opsDemoQrThumb");
    if (thumb && !thumb.__wired) {
      thumb.__wired = true;
      thumb.addEventListener("click", openDialog);
      thumb.addEventListener("error", () => {
        // visible hint if QR file missing
        thumb.title = "QR-Bild nicht gefunden: lege qr-vcard-opsdeck360.png in den gleichen Ordner wie das HTML";
      }, { once: true });
    }
  }

  if (document.readyState === "loading") {
    document.addEventListener("DOMContentLoaded", init);
  } else {
    init();
  }

  // retry a few times because header/footers may render late
  let tries = 0;
  const t = setInterval(() => {
    tries++;
    init();
    if (tries > 30) clearInterval(t);
  }, 250);
})();
