(() => {
  "use strict";

  function whenReady(fn) {
    const i = setInterval(() => {
      const header = document.querySelector("header, .app-header");
      if (header) {
        clearInterval(i);
        fn(header);
      }
    }, 200);
  }

  function addInfoButton(header) {
    if (header.querySelector("#opsDemoInfoBtn")) return;

    const btn = document.createElement("button");
    btn.id = "opsDemoInfoBtn";
    btn.className = "btn btn-ghost";
    btn.title = "Demo-Information";
    btn.textContent = "ℹ";

    btn.onclick = () => openDialog();
    header.appendChild(btn);
  }

  function openDialog() {
    let dlg = document.getElementById("opsDemoInfoDialog");
    if (!dlg) {
      dlg = document.createElement("dialog");
      dlg.id = "opsDemoInfoDialog";
      dlg.className = "dialog";
      dlg.innerHTML = `
        <div class="card">
          <div class="ops-dialog-header">
            <div class="ops-dialog-title">OpsDeck360 – DEMO</div>
            <button class="btn btn-ghost" onclick="this.closest('dialog').close()">✕</button>
          </div>

          <div class="ops-dialog-body" style="text-align:center">
            <p><b>Kontakt</b><br>
              Torsten Döpke<br>
              Diplom Wirt.-Info<br>
              <a href="mailto:info@opsdeck360.de">info@opsdeck360.de</a>
            </p>

            <img src="./torsten_doepke_vcard_qr_no_umlaut.png"
                 style="max-width:300px;border-radius:12px;border:1px solid rgba(255,255,255,.2)">
          </div>
        </div>
      `;
      document.body.appendChild(dlg);
    }
    dlg.showModal();
  }

  function addFooter() {
    if (document.getElementById("opsDemoFooter")) return;

    const f = document.createElement("footer");
    f.id = "opsDemoFooter";
    f.style.cssText =
      "text-align:center;opacity:.7;font-size:13px;margin:16px 0";

    f.innerHTML =
      'Torsten Döpke • Diplom Wirt.-Info • <a href="mailto:info@opsdeck360.de">info@opsdeck360.de</a>';

    document.body.appendChild(f);
  }

  whenReady((header) => {
    addInfoButton(header);
    addFooter();
  });
})();
