// ops-header-Lagerverwaltung.js (STABLE themed header + info dialog)
// Drop-in replacement: no dependencies, no async/await, no CSS removal.
(() => {
  "use strict";
  if (window.__opsHeaderLagerverwaltungLoaded) return;
  window.__opsHeaderLagerverwaltungLoaded = true;

  const HEADER_MAX = 1360; // match .app-main max-width
  const $ = (sel, root = document) => root.querySelector(sel);

  function injectCss() {
    if (document.getElementById("opsHdrLvCss")) return;
    const style = document.createElement("style");
    style.id = "opsHdrLvCss";
    style.textContent = `
      :root{ --ops-hdr-max:${HEADER_MAX}px; --ops-hdr-h:84px; }
      html{ scroll-padding-top: var(--ops-hdr-h); }

      header.app-header{
        position: sticky;
        top: 0;
        z-index: 1000;
        border-bottom: 1px solid rgba(148,163,184,0.22);
        box-shadow: 0 10px 28px rgba(0,0,0,0.40);
        background:
          radial-gradient(900px 280px at 15% 0%, rgba(56,189,248,0.14), transparent 60%),
          radial-gradient(700px 260px at 95% 10%, rgba(168,85,247,0.12), transparent 62%),
          linear-gradient(180deg, rgba(15,23,42,0.92), rgba(2,6,23,0.78));
        backdrop-filter: blur(8px);
      }

      #header-inner{
        max-width: var(--ops-hdr-max);
        margin: 0 auto;
        padding: 16px 18px;
        min-height: var(--ops-hdr-h);
        display: flex;
        align-items: center;
        gap: 16px;
        box-sizing: border-box;
      }

      .ops-hdr-left{ display:flex; align-items:center; gap:12px; min-width: 260px; }
      .ops-hdr-right{ margin-left:auto; display:flex; align-items:center; gap:10px; flex-wrap:wrap; justify-content:flex-end; }

      .ops-hdr-brand{ display:flex; align-items:center; gap:10px; min-width:0; }
      .ops-hdr-logo{
        width:34px; height:34px; border-radius:8px;
        display:grid; place-items:center;
        font-weight:900; letter-spacing:.02em;
        background: rgba(255,255,255,.06);
        border: 1px solid rgba(255,255,255,.14);
      }
      .ops-hdr-titles{ display:flex; flex-direction:column; line-height:1.05; min-width:0; }
      .ops-hdr-main{ font-weight:800; font-size: 20px; letter-spacing:-0.02em; }
      .ops-hdr-sub{ font-size: 13px; opacity:.82; white-space:nowrap; overflow:hidden; text-overflow:ellipsis; max-width: 520px; }

      .ops-hdr-badge{
        font-size: 13px;
        padding: 5px 10px;
        border-radius: 999px;
        border: 1px solid rgba(255,255,255,.16);
        background: rgba(255,255,255,.06);
        font-weight: 800;
        letter-spacing: .10em;
      }

      .ops-hdr-pill{
        font-size: 14px;
        padding: 6px 10px;
        border-radius: 12px;
        border: 1px solid rgba(255,255,255,.14);
        background: rgba(255,255,255,.05);
        opacity: .95;
        white-space: nowrap;
      }

      .ops-hdr-icon{
        width: 38px; height: 38px;
        padding: 0 !important;
        display:inline-flex; align-items:center; justify-content:center;
        border-radius: 12px;
      }

      /* Make sure dialog matches your existing theme (ops-Lagerverwaltung.css) */
      dialog.dialog{ border:none; padding:0; background:transparent; }
      dialog.dialog::backdrop{ background: rgba(0,0,0,0.55); }
      #opsDemoInfoDialog .card{ max-width: 920px; width: 92vw; }
      #opsDemoInfoDialog .ops-demo-section h4{ margin:0 0 6px 0; font-size:14px; opacity:.9; letter-spacing:.02em; }
      #opsDemoInfoDialog .ops-demo-section p{ margin:0; opacity:.92; }
      #opsDemoInfoDialog ul{ margin:10px 0 0 18px; opacity:.92; }
      #opsDemoInfoDialog hr{ border:none; border-top:1px solid rgba(148,163,184,0.22); margin:14px 0; }
    `;
    document.head.appendChild(style);
  }

  function pad2(n){ return String(n).padStart(2,"0"); }
  function formatTime(d){
    return `${pad2(d.getDate())}.${pad2(d.getMonth()+1)}.${d.getFullYear()} ${pad2(d.getHours())}:${pad2(d.getMinutes())}`;
  }

  function getLang() {
    const v =
      (safeGetLS("ops_lang") || safeGetLS("opsLang") || safeGetLS("lang") ||
       document.documentElement.lang || "de");
    return String(v).slice(0,2).toLowerCase() === "en" ? "en" : "de";
  }
  function safeGetLS(k){ try { return localStorage.getItem(k); } catch(_) { return null; } }
  function safeSetLS(k,v){ try { localStorage.setItem(k,v); } catch(_) {} }

  function setLang(next) {
    const l = (String(next).slice(0,2).toLowerCase()==="en") ? "en" : "de";
    safeSetLS("ops_lang", l);
    safeSetLS("opsLang", l);
    safeSetLS("lang", l);
    document.documentElement.lang = l;
    // notify and reload (demo: simplest & robust)
    try { window.dispatchEvent(new CustomEvent("ops:langchange", { detail:{ lang:l } })); } catch(_) {}
    try { window.dispatchEvent(new CustomEvent("opsLangChanged", { detail:{ lang:l } })); } catch(_) {}
    try { location.reload(); } catch(_) {}
  }

  function ensureDialog() {
    let dlg = $("#opsDemoInfoDialog");
    if (dlg) return dlg;

    dlg = document.createElement("dialog");
    dlg.id = "opsDemoInfoDialog";
    dlg.className = "dialog";
    dlg.innerHTML = `
      <div class="card">
        <div class="ops-dialog-header">
          <div>
            <div class="ops-dialog-title">OpsDeck360 – Lagerverwaltung (DEMO)</div>
            <div class="ops-dialog-note">Demo-Informationen / Demo information</div>
          </div>
          <button type="button" class="btn btn-ghost" data-close title="Schließen / Close">✕</button>
        </div>

        <div class="ops-demo-section">
          <h4>Deutsch</h4>
          <p>
            Diese Demo zeigt die wichtigsten Funktionen der OpsDeck360‑Lagerverwaltung zum Ausprobieren.
            Du kannst alle Abläufe testen – <b>Suchen</b>, <b>Filtern</b>, <b>Wareneingang</b>, <b>Warenausgang</b>,
            <b>Aktionen</b>, <b>Dialoge</b>, <b>Belegliste</b> usw. – ohne dass Daten dauerhaft gespeichert werden.
          </p>
          <ul>
            <li>Änderungen werden nur in der laufenden Sitzung gehalten.</li>
            <li>Nach einem Neustart startet die Demo wieder im Ausgangszustand („Reset“).</li>
            <li>Die Tabelle wird automatisch aus <b>Lagerverwaltung_Produktion.csv</b> im gleichen Ordner geladen.</li>
            <li>Die Demo ist zweisprachig (Deutsch/Englisch) und kann in der Oberfläche umgestellt werden.</li>
          </ul>
          <p style="margin-top:10px">
            <b>Kontakt:</b> Torsten Döpke (Dipl.-Wirt.-Inf.) – E‑Mail:
            <a href="mailto:info@opsdeck360.de">info@opsdeck360.de</a>
          </p>
        </div>

        <hr>

        <div class="ops-demo-section">
          <h4>English</h4>
          <p>
            This demo lets you try the core features of OpsDeck360 Inventory Management.
            You can test all workflows – <b>search</b>, <b>filters</b>, <b>inbound</b>, <b>outbound</b>,
            <b>actions</b>, <b>dialogs</b>, <b>document list</b>, etc. – without permanently saving data.
          </p>
          <ul>
            <li>Changes are kept only for the current session.</li>
            <li>After restart, the demo returns to its initial state (“Reset”).</li>
            <li>The table is automatically loaded from <b>Lagerverwaltung_Produktion.csv</b> in the same folder.</li>
            <li>The demo is bilingual (German/English) and can be switched in the UI.</li>
          </ul>
          <p style="margin-top:10px">
            <b>Contact:</b> Torsten Döpke (Dipl.-Wirt.-Inf.) – Email:
            <a href="mailto:info@opsdeck360.de">info@opsdeck360.de</a>
          </p>
        </div>

        <div class="card-footer" style="display:flex;justify-content:flex-end;gap:10px;margin-top:14px;">
          <button type="button" class="btn" data-close>Schließen / Close</button>
        </div>
      </div>
    `;
    document.body.appendChild(dlg);

    // close handlers
    dlg.addEventListener("click", (ev) => {
      if (ev.target === dlg) { try { dlg.close(); } catch(_) {} }
    });
    dlg.querySelectorAll("[data-close]").forEach((b) => {
      b.addEventListener("click", () => { try { dlg.close(); } catch(_) {} });
    });

    return dlg;
  }

  function safeConfirmReset() {
    const lang = getLang();
    const msg = (lang === "de")
      ? "Demo zurücksetzen? (Änderungen dieser Sitzung gehen verloren)"
      : "Reset demo? (Changes in this session will be lost)";
    return window.confirm(msg);
  }


  function ensureFooter() {
    if (document.getElementById("opsDemoFooter")) return;

    const footer = document.createElement("footer");
    footer.id = "opsDemoFooter";
    footer.className = "app-footer";
    footer.innerHTML = `
      <div class="ops-footer-inner">
        <span>Torsten Döpke • Diplom Wirt.-Info.</span>
        <span class="ops-footer-sep">•</span>
        <a href="mailto:info@opsdeck360.de">info@opsdeck360.de</a>
      </div>
    `;
    document.body.appendChild(footer);

    // minimal themed footer CSS (non-destructive)
    if (!document.getElementById("opsDemoFooterCss")) {
      const st = document.createElement("style");
      st.id = "opsDemoFooterCss";
      st.textContent = `
        footer.app-footer{
          border-top: 1px solid rgba(148,163,184,0.18);
          margin-top: 18px;
          background: rgba(2,6,23,0.35);
          backdrop-filter: blur(6px);
        }
        .ops-footer-inner{
          max-width: var(--ops-hdr-max, 1360px);
          margin: 0 auto;
          padding: 12px 16px;
          display:flex;
          gap:10px;
          justify-content:center;
          align-items:center;
          flex-wrap:wrap;
          opacity: .9;
          font-size: 13px;
        }
        .ops-footer-inner a{
          color: inherit;
          text-decoration: none;
          border-bottom: 1px dotted rgba(255,255,255,0.35);
        }
        .ops-footer-inner a:hover{
          border-bottom-color: rgba(255,255,255,0.7);
        }
        .ops-footer-sep{ opacity:.6; }
      `;
      document.head.appendChild(st);
    }
  }

  function render() {
    ensureFooter();
    injectCss();

    const headerInner = document.getElementById("header-inner");
    if (!headerInner) return;

    const host = location && location.host ? location.host : "lokal";
    const lang = getLang();

    // best-effort user/role (demo default)
    const userText = safeGetLS("ops_user") || "demo (admin)";
    const roleText = safeGetLS("ops_role") || "Admin";

    headerInner.innerHTML = `
      <div class="ops-hdr-left">
        <div class="ops-hdr-brand">
          <div class="ops-hdr-logo">OD</div>
          <div class="ops-hdr-titles">
            <div class="ops-hdr-main">OpsDeck360</div>
            <div class="ops-hdr-sub">Lokaler Server • ${host}</div>
          </div>
        </div>
        <span class="ops-hdr-badge">DEMO</span>
      </div>

      <div class="ops-hdr-right">
        <button type="button" class="btn ops-hdr-icon is-info" id="opsHdrInfoBtn" title="Info" aria-label="Info">i</button>
        <span class="ops-hdr-pill" id="opsHdrTime"></span>
        <span class="ops-hdr-pill" id="opsHdrUser">${lang==="de" ? "User" : "User"}: ${userText}</span>
        <button type="button" class="btn" id="opsHdrResetBtn">Reset</button>
        <button type="button" class="btn" id="opsHdrLangBtn">${lang==="de" ? "EN" : "DE"}</button>
        <span class="ops-hdr-pill" id="opsHdrRole">${lang==="de" ? "Rolle" : "Role"}: ${roleText}</span>
      </div>
    `;

    // time ticker
    const timeEl = document.getElementById("opsHdrTime");
    const tick = () => { if (timeEl) timeEl.textContent = formatTime(new Date()); };
    tick();
    if (window.__opsHdrTimer) clearInterval(window.__opsHdrTimer);
    window.__opsHdrTimer = setInterval(tick, 15000);

    // info
    const infoBtn = document.getElementById("opsHdrInfoBtn");
    if (infoBtn) {
      infoBtn.addEventListener("click", () => {
        const dlg = ensureDialog();
        try { dlg.showModal(); } catch(_) { dlg.setAttribute("open","open"); }
      });
    }

    // reset
    const resetBtn = document.getElementById("opsHdrResetBtn");
    if (resetBtn) {
      resetBtn.addEventListener("click", () => {
        if (!safeConfirmReset()) return;
        try { localStorage.clear(); } catch(_) {}
        try { sessionStorage.clear(); } catch(_) {}
        location.reload();
      });
    }

    // language
    const langBtn = document.getElementById("opsHdrLangBtn");
    if (langBtn) {
      langBtn.addEventListener("click", () => {
        setLang(getLang() === "de" ? "en" : "de");
      });
    }
  }

  // init
  if (document.readyState === "loading") document.addEventListener("DOMContentLoaded", render);
  else render();
})();
